/******/ (() => { // webpackBootstrap
/******/     "use strict";
/******/     var __webpack_modules__ = ({

/***/ "./src/background/index.ts":
/*!*********************************!*\
  !*** ./src/background/index.ts ***!
  \*********************************/
/***/ (function() {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const API_BASE_URL = 'https://def-test.koders.in/api';
// Function to fetch and store all necessary data
function fetchAndStoreData() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            // console.log('Starting fetchAndStoreData function');
            const { token } = yield chrome.storage.local.get(['token']);
            if (!token) {
                console.log('No token found, skipping data fetch');
                return;
            }
            // console.log('Token found, data will be fetched by popup using Supabase API');
            // Data fetching is now handled by the popup using the new Supabase API
            // This function is kept for backward compatibility but doesn't fetch data anymore
        }
        catch (error) {
            console.error('Error in fetchAndStoreData:', error);
        }
    });
}
// Clear stored data
function clearStoredData() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            yield chrome.storage.local.remove([
                'passwords', 'cards', 'notes', 'personalInfo', 'folders', 'userProfile', 'token', 'credentials',
                'pendingLoginData', 'pendingCardData', 'pendingPersonalData', 'tempLoginData', 'currentView',
                'userObj', 'userData', 'isAppLocked'
            ]);
            // console.log('All stored data cleared');
        }
        catch (error) {
            console.error('Error clearing stored data:', error);
        }
    });
}
// Handle save credentials
function handleSaveCredentials(data) {
    const { url, username, password } = data;
    chrome.storage.local.get(['credentials'], (result) => __awaiter(this, void 0, void 0, function* () {
        const credentials = result.credentials || [];
        const alreadyExists = credentials.some((cred) => cred.url === url && cred.username === username);
        if (!alreadyExists) {
            credentials.push({ url, username, password, title: url });
            yield chrome.storage.local.set({ credentials });
            console.log('Credentials saved for:', url);
        }
        else {
            console.log('Credentials already exist for:', url);
        }
    }));
}
// Handle save personal details
function handleSavePersonalDetails(data) {
    const { email, phone, address1, zipcode } = data;
    chrome.storage.local.get(['personalInfo'], (result) => __awaiter(this, void 0, void 0, function* () {
        const personalInfo = result.personalInfo || [];
        const alreadyExists = personalInfo.some((item) => item.email === email && item.phone === phone && item.address1 === address1 && item.zipcode === zipcode);
        if (!alreadyExists) {
            personalInfo.push(Object.assign(Object.assign({}, data), { _id: Date.now().toString(), created_at: new Date().toISOString(), updated_at: new Date().toISOString() }));
            yield chrome.storage.local.set({ personalInfo });
            // console.log('Personal details saved for:', email);
        }
        else {
            console.log('Personal details already exist for:', email);
        }
    }));
}
// Handle save card details
function handleSaveCardDetails(data) {
    const { cardNumber, cardholder, expDate } = data;
    chrome.storage.local.get(['cards'], (result) => __awaiter(this, void 0, void 0, function* () {
        const cards = result.cards || [];
        const alreadyExists = cards.some((item) => item.cardNumber === cardNumber && item.cardholder === cardholder && item.expDate === expDate);
        if (!alreadyExists) {
            cards.push(Object.assign(Object.assign({}, data), { _id: Date.now().toString(), created_at: new Date().toISOString(), updated_at: new Date().toISOString() }));
            yield chrome.storage.local.set({ cards });
            // console.log('Card details saved for:', cardNumber);
        }
        else {
            console.log('Card details already exist for:', cardNumber);
        }
    }));
}
// Handle deep links for item operations using runtime message
// This will be triggered by the popup when deep links are clicked
function handleDeepLinkAction(action, params) {
    return __awaiter(this, void 0, void 0, function* () {
        // console.log('Deep link action:', action, params.toString());
        if (action === 'delete-item') {
            const itemType = params.get('itemType');
            const itemId = params.get('itemId');
            if (itemType && itemId) {
                // console.log('Deleting item:', itemType, itemId);
                // Handle item deletion based on type
                yield handleItemDeletion(itemType, itemId);
                // Notify content script to refresh autofill data
                chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
                    var _a;
                    if ((_a = tabs[0]) === null || _a === void 0 ? void 0 : _a.id) {
                        chrome.tabs.sendMessage(tabs[0].id, {
                            type: 'REFRESH_AUTOFILL_DATA',
                            action: 'item_deleted',
                            itemType: itemType,
                            itemId: itemId
                        });
                    }
                });
            }
        }
    });
}
// Function to handle item deletion
function handleItemDeletion(itemType, itemId) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            // Get current storage data
            const result = yield chrome.storage.local.get([itemType === 'password' ? 'credentials' : itemType === 'creditCard' ? 'cards' : 'personalInfo']);
            let storageKey = '';
            if (itemType === 'password')
                storageKey = 'credentials';
            else if (itemType === 'creditCard')
                storageKey = 'cards';
            else if (itemType === 'personalInfo')
                storageKey = 'personalInfo';
            if (storageKey && result[storageKey]) {
                // Remove the item from storage
                const updatedItems = result[storageKey].filter((item) => item._id !== itemId && item.id !== itemId);
                yield chrome.storage.local.set({ [storageKey]: updatedItems });
                // console.log(`Item deleted from ${storageKey}:`, itemId);
            }
        }
        catch (error) {
            console.error('Error handling item deletion:', error);
        }
    });
}
// Startup and install triggers
chrome.runtime.onStartup.addListener(() => {
    // console.log('Extension started');
    fetchAndStoreData();
});
chrome.runtime.onInstalled.addListener(() => {
    // console.log('Extension installed');
    fetchAndStoreData();
});
// Listen for messages
chrome.runtime.onMessage.addListener((message, _sender, sendResponse) => {
    // console.log('Received message:', message);
    const handleMessage = () => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e;
        try {
            switch (message.type) {
                case 'POPUP_OPENED':
                    yield fetchAndStoreData();
                    sendResponse({ success: true });
                    break;
                case 'CHECK_AUTH':
                    const authResult = yield chrome.storage.local.get(['token']);
                    sendResponse({ isAuthenticated: !!authResult.token });
                    break;
                case 'LOGOUT':
                    //  console.log('Logout requested, clearing all stored data');
                    yield clearStoredData();
                    console.log('Logout completed successfully');
                    break;
                case 'SAVE_CREDENTIALS':
                    yield handleSaveCredentials(message.data);
                    break;
                case 'PROMPT_SAVE_DATA':
                    // Save data to local storage
                    try {
                        const dataToSave = Object.assign(Object.assign({}, message.payload), { formData: Object.assign(Object.assign({}, message.payload.formData), { password: ((_a = message.payload.formData) === null || _a === void 0 ? void 0 : _a.password) || '', username: ((_b = message.payload.formData) === null || _b === void 0 ? void 0 : _b.username) || ((_c = message.payload.formData) === null || _c === void 0 ? void 0 : _c.email) || '', email: ((_d = message.payload.formData) === null || _d === void 0 ? void 0 : _d.email) || '', title: ((_e = message.payload.formData) === null || _e === void 0 ? void 0 : _e.title) || '' }) });
                        // console.log('Saving data to storage:', dataToSave);
                        // Store data based on type
                        if (message.payload.type === 'password') {
                            yield chrome.storage.local.set({
                                pendingLoginData: dataToSave
                            });
                        }
                        else if (message.payload.type === 'card') {
                            yield chrome.storage.local.set({
                                pendingCardData: dataToSave
                            });
                        }
                        else if (message.payload.type === 'personal') {
                            yield chrome.storage.local.set({
                                pendingPersonalData: dataToSave
                            });
                        }
                        // Check if user is logged in
                        const result = yield chrome.storage.local.get(['token']);
                        if (result.token) {
                            // User is logged in, open popup with appropriate view
                            let view = 'saveLoginDetails';
                            if (message.payload.type === 'card') {
                                view = 'saveCardDetails';
                            }
                            else if (message.payload.type === 'personal') {
                                view = 'savePersonalDetails';
                            }
                            // console.log('User is logged in, opening popup for:', message.payload.type);
                            // Store the currentView in storage
                            yield chrome.storage.local.set({ currentView: view });
                            // Open the extension popup (allow even when app is locked)
                            chrome.action.openPopup();
                        }
                        else {
                            // User is not logged in, silently ignore the save request
                            // This prevents unwanted popup windows when user is not authenticated
                            console.log('User not logged in, ignoring save request for:', message.payload.type);
                        }
                    }
                    catch (error) {
                        console.error('Error handling PROMPT_SAVE_DATA:', error);
                    }
                    break;
                case 'SAVE_PERSONAL_DETAILS':
                    yield handleSavePersonalDetails(message.data);
                    break;
                case 'SAVE_CARD_DETAILS':
                    yield handleSaveCardDetails(message.data);
                    break;
                case 'PROMPT_SAVE_CARD_DETAILS':
                    try {
                        yield chrome.storage.local.set({ pendingCardData: message.payload });
                        const { token } = yield chrome.storage.local.get(['token']);
                        if (token) {
                            // Allow opening even when app is locked
                            chrome.action.openPopup();
                        }
                        else {
                            // User is not logged in, silently ignore the save request
                            console.log('User not logged in, ignoring card save request');
                        }
                    }
                    catch (err) {
                        console.error('Error handling PROMPT_SAVE_CARD_DETAILS:', err);
                    }
                    break;
                case 'PROMPT_SAVE_PERSONAL_DETAILS':
                    try {
                        yield chrome.storage.local.set({ pendingPersonalData: message.payload });
                        const { token } = yield chrome.storage.local.get(['token']);
                        if (token) {
                            // Allow opening even when app is locked
                            chrome.action.openPopup();
                        }
                        else {
                            // User is not logged in, silently ignore the save request
                            console.log('User not logged in, ignoring personal details save request');
                        }
                    }
                    catch (err) {
                        console.error('Error handling PROMPT_SAVE_PERSONAL_DETAILS:', err);
                    }
                    break;
                // New fallback message handlers for content script failures
                case 'OPEN_SAVE_LOGIN_POPUP':
                    try {
                        yield chrome.storage.local.set({ pendingLoginData: message.data });
                        const { token } = yield chrome.storage.local.get(['token']);
                        if (token) {
                            yield chrome.storage.local.set({ currentView: 'saveLoginDetails' });
                            // Allow opening even when app is locked
                            chrome.action.openPopup();
                        }
                    }
                    catch (err) {
                        console.error('Error handling OPEN_SAVE_LOGIN_POPUP:', err);
                    }
                    break;
                case 'OPEN_SAVE_PERSONAL_POPUP':
                    try {
                        yield chrome.storage.local.set({ pendingPersonalData: message.data });
                        const { token } = yield chrome.storage.local.get(['token']);
                        if (token) {
                            yield chrome.storage.local.set({ currentView: 'savePersonalDetails' });
                            // Allow opening even when app is locked
                            chrome.action.openPopup();
                        }
                    }
                    catch (err) {
                        console.error('Error handling OPEN_SAVE_PERSONAL_POPUP:', err);
                    }
                    break;
                case 'OPEN_SAVE_CARD_POPUP':
                    try {
                        yield chrome.storage.local.set({ pendingCardData: message.data });
                        const { token } = yield chrome.storage.local.get(['token']);
                        if (token) {
                            yield chrome.storage.local.set({ currentView: 'saveCardDetails' });
                            // Allow opening even when app is locked
                            chrome.action.openPopup();
                        }
                    }
                    catch (err) {
                        console.error('Error handling OPEN_SAVE_CARD_POPUP:', err);
                    }
                    break;
                case 'HANDLE_DEEP_LINK':
                    try {
                        const { action, url } = message;
                        if (action && url) {
                            const urlObj = new URL(url);
                            const params = new URLSearchParams(urlObj.search);
                            yield handleDeepLinkAction(action, params);
                        }
                    }
                    catch (err) {
                        console.error('Error handling deep link:', err);
                    }
                    break;
            }
        }
        catch (error) {
            console.error('Error handling message:', error);
        }
    });
    handleMessage();
    return true;
});


/***/ })

/******/     });
/************************************************************************/
/******/
/******/     // startup
/******/     // Load entry module and return exports
/******/     // This entry module is referenced by other modules so it can't be inlined
/******/     var __webpack_exports__ = {};
/******/     __webpack_modules__["./src/background/index.ts"]();
/******/
/******/ })()
;
//# sourceMappingURL=background.js.map
